%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FileName:            mfRxDespread.m
%  Description:         
%  Reference:           3GPP TS 25.213, 5.1 Spreading
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Parameter List:       
%       Output Parameter
%           out_data	 
%       Input Parameter
%           input_data	
%           sf          ȡֵΧ48512
%           ovsf_No     ƵţȡֵΧ0~sf-1
%           sample_rate 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  History
%    1. Date:           2017-12-1
%       Author:         david.lee
%       Version:        1.0 
%       Modification:   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [out_data] = CDMA_RxDespread(input_data, sf, ovsf_No, sample_rate)

%% ʼ
out_data = zeros(1, 2560*6/sf);  %ֻȡǰ10ʱ϶
spreadLength =  sample_rate*sf; %#ok

%% ʵ
%OVSFƵ
%OVSFƵ
COVSF2 = [1,1;1,-1];
COVSF4 = zeros(4, 4);
COVSF8 = zeros(8, 8);
COVSF16 = zeros(16, 16);
COVSF32 = zeros(32, 32);
COVSF64 = zeros(64, 64);
COVSF128 = zeros(128, 128);
COVSF256 = zeros(256, 256);
COVSF512 = zeros(512, 512);
%SF4~512ȫOVSFƵ
%SF = 4
for n = 1:4
    if mod(n,2) == 1
       COVSF4(n,:) = [COVSF2((n+1)/2,:),COVSF2((n+1)/2,:)];
    else
       COVSF4(n,:) = [COVSF2(n/2,:),COVSF2(n/2,:)*(-1)];
    end
end
%SF = 8      
for n = 1:8
    if mod(n,2) == 1
       COVSF8(n,:) = [COVSF4((n+1)/2,:),COVSF4((n+1)/2,:)];
    else
       COVSF8(n,:) = [COVSF4(n/2,:),COVSF4(n/2,:)*(-1)];
    end
end
%SF = 16
for n = 1:16
    if mod(n,2) == 1
       COVSF16(n,:) = [COVSF8((n+1)/2,:),COVSF8((n+1)/2,:)];
    else
       COVSF16(n,:) = [COVSF8(n/2,:),COVSF8(n/2,:)*(-1)];
    end
end
%SF = 32
for n = 1:32
    if mod(n,2) == 1
       COVSF32(n,:) = [COVSF16((n+1)/2,:),COVSF16((n+1)/2,:)];
    else
       COVSF32(n,:) = [COVSF16(n/2,:),COVSF16(n/2,:)*(-1)];
    end
end
%SF = 64
for n = 1:64
    if mod(n,2) == 1
       COVSF64(n,:) = [COVSF32((n+1)/2,:),COVSF32((n+1)/2,:)];
    else
       COVSF64(n,:) = [COVSF32(n/2,:),COVSF32(n/2,:)*(-1)];
    end
end
%SF = 128
for n = 1:128
    if mod(n,2) == 1
       COVSF128(n,:) = [COVSF64((n+1)/2,:),COVSF64((n+1)/2,:)];
    else
       COVSF128(n,:) = [COVSF64(n/2,:),COVSF64(n/2,:)*(-1)];
    end
end
%SF = 256
for n = 1:256
    if mod(n,2) == 1
       COVSF256(n,:) = [COVSF128((n+1)/2,:),COVSF128((n+1)/2,:)];
    else
       COVSF256(n,:) = [COVSF128(n/2,:),COVSF128(n/2,:)*(-1)];
    end
end
%SF = 512
for n = 1:512
    if mod(n,2) == 1
       COVSF512(n,:) = [COVSF256((n+1)/2,:),COVSF256((n+1)/2,:)];
    else
       COVSF512(n,:) = [COVSF256(n/2,:),COVSF256(n/2,:)*(-1)];
    end
end
%ҪOVSF
switch sf
    case 4
        ovsf_code = COVSF4(ovsf_No+1, :);
    case 8
        ovsf_code = COVSF8(ovsf_No+1, :);
    case 16
        ovsf_code = COVSF16(ovsf_No+1, :);        
    case 32
        ovsf_code = COVSF32(ovsf_No+1, :);
    case 64
        ovsf_code = COVSF64(ovsf_No+1, :);
    case 128
        ovsf_code = COVSF128(ovsf_No+1, :);
    case 256
        ovsf_code = COVSF256(ovsf_No+1, :); 
    case 512
        ovsf_code = COVSF512(ovsf_No+1, :); 
    otherwise
        fprintf('error:mfOvsfCodeGenerateĲsf\n');  
end
ovsfCodeSample = zeros(1, sf*sample_rate);
for n = 1:sf
    for m = 1:sample_rate
        ovsfCodeSample((n-1)*sample_rate + m) = ovsf_code(n);
    end
end

%
spreadLength =  sample_rate*sf;
for data_num=1:2560*6/sf
    for n=1:spreadLength
        out_data(data_num)=out_data(data_num)+input_data(1, (data_num-1)*spreadLength+n)/ovsfCodeSample(n);
    end
end

end